unit Unit1;

interface

{==============================================================================}
{ This demo show how to use information about hypertext item.                  }
{------------------------------------------------------------------------------}
{ Key methods:                                                                 }
{ - GetJumpPointItemNo;                                                        }
{ - methods for obtaining information about items (see first demo in this      }
{   group.                                                                     }
{ Useful if text is self-describing (for example, for WWW addresses).          }
{==============================================================================}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVStyle, ExtCtrls, RVScroll, RichView, StdCtrls, ImgList;

type
  TForm1 = class(TForm)
    RichView1: TRichView;
    Panel1: TPanel;
    RVStyle1: TRVStyle;
    ImageList1: TImageList;
    Image1: TImage;
    procedure FormCreate(Sender: TObject);
    procedure RichView1Jump(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var ico: TIcon;
begin
  RichView1.AddNL('Hypertext',1,1);
  RichView1.AddNL('Some text styles can be chosen as hypertext styles. ',0,0);
  RichView1.AddNL('Like this one.',4,-1);
  RichView1.AddNL(' You can have as many hypertext styles as you want.  ',0,-1);
  RichView1.AddNL('Here is one more.',5,-1);
  RichView1.AddNL('Images from Image Lists also can be hypertext: ',0,0);
  RichView1.AddHotspotEx('Pen Image', 0,1, ImageList1, -1);
  RichView1.AddNL(' Such images are called "hotspots".',0,-1);
  RichView1.AddNL('Normal images also can be hypertext: ',0,0);
  ico := TIcon.Create;
  ico.Assign(Image1.Picture.Graphic);
  RichView1.AddHotPicture('Bobo', ico, -1, rvvaBaseLine);

  RichView1.Format;
end;

procedure TForm1.RichView1Jump(Sender: TObject; id: Integer);
var ItemNo: Integer;
begin
  ItemNo := RichView1.GetJumpPointItemNo(id);
  Panel1.Caption := 'Clicked: '+RichView1.GetItemText(ItemNo);
end;

end.
